; -----------------------------------------------------------------------------
; CPUSPEED.ASM  CPU speed measurement routine for TMi0SDGL 2      Version 2.01
;
; Too-Much-In-One-So-Don't-Get-Lost(tm) Revision 2 CPU/FPU Detection Library
; Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.
; -----------------------------------------------------------------------------
; This file contains Speed routine that plays part in CPU clock frequency
; calculation. Algorithm was taken from Norton SysInfo as well as several
; constants.

        INCLUDE HEADER.ASH

        PUBLIC  Speed

; --- Windows detection and critical section handling

isUnderWin      proc near
        mov     ax,1600h
        int     2Fh
        or      al,al
        jz      @@nowin
        cmp     al,80h
        jz      @@nowin
        stc
        ret
@@nowin:
        clc
        ret
        endp

winStartCritical        proc near
        push    ax
        call    IsUnderWin
        jnc     @@Q
        mov     ax,1681h
        int     2Fh
@@Q:
        pop     ax
        ret
        endp

winEndCritical          proc near
        push    ax
        call    IsUnderWin
        jnc     @@Q
        mov     ax,1682h
        int     2Fh
@@Q:
        pop     ax
        ret
        endp

; ------ Quarterdeck DESQview detection and critical section handling

isUnderDV       proc near
        mov     ax,2B01h
        push    cx dx
        mov     cx,4445h
        mov     dx,5351h
        int     21h
        pop     dx cx
        cmp     al,0FFh
        jz      @@noDV
        stc
        ret
@@noDV:
        clc
        ret
        endp

DVStartCritical proc near
        push    ax
        call    isUnderDV
        jnc     @@Q
        mov     ax,101Bh
        int     15h
@@Q:
        pop     ax
        ret
        endp

DVEndCritical   proc near
        push    ax
        call    isUnderDV
        jnc     @@Q
        mov     ax,101Ch
        int     15h
@@Q:
        pop     ax
        ret
        endp

; ------ Speed routine implementation

Speed   PROC  DIST
LOCAL   Stage : Word            ; local variable to differ test stages
        mov     cx,2
        mov     Stage,0
        call    winStartCritical; enter Windows critical section
        call    DVStartCritical ; enter DESQview critical section
                                ; IBM OS/2 doesn't provide a critical section
                                ; mechanism, so you should set HW_TIMER = ON
                                ; in DOS Box settings to get correct result.
@@1:
        mov     speedShift,cx   ; initialize speedShift
        push    Stage
        call    speedTest       ; do a code section 101 times
        cmp     ax,1000h
        jnb     @@2
        mov     cx,speedShift
        shl     cx,1            ; repeat test with increasing values until
        shl     cx,1            ; we get reasonable time value worth working
        shl     cx,1            ; with
        jmp     @@1
@@2:
        push    ax
        mov     cx,speedShift   ; no do the same code section 100 times less
        mov     Stage,1
        push    Stage
        call    speedTest
        call    winEndCritical  ; exit Windows critical section
        call    DVEndCritical   ; exit DESQview critical section
        pop     dx
        sub     dx,ax           ; now we got time how long 100*shift instructions
        xchg    ax,dx           ; were performed - knowing number of ticks it
        ret                     ; takes for each CPU type we can compute the
        ENDP                    ; CPU clock frequency.

speedTest       PROC    NEAR
ARG     Stage : Byte

        push    si di
        clr     dx
        mov     si,0AAAAh
        mov     bx,05555h
        in      al,61h          ; initialize hardware timer
        jmp     $+2
        and     al,0FCh
        out     61h,al
        jmp     $+2
        mov     al,0B4h
        out     43h,al
        jmp     $+2
        clr     al
        out     42h,al
        jmp     $+2
        out     42h,al
        jmp     $+2
        in      al,61h
        mov     di,ax
        or      al,01
        cmp     Stage,0
        jnz     @@2
@@1:
        cli
        out     61h,al
@@3:
Sprite  equ     <8Bh, 0C6h, 0F7h, 0F3h>
; these codes are equivalent to
;       MOV     AX,SI
;       DIV     BX

        db      101     dup(Sprite)
        dec     cx
        jz      @@4
        jmp     @@3
@@2:
        cli
        out     61h,al
@@5:
        db      Sprite
        dec     cx
        jz      @@4
        jmp     @@5

@@4:
        mov     ax,di           ; shut down timer and get results
        out     61h,al
        jmp     $+2
        sti
        in      al,42h
        jmp     $+2
        xchg    ah,al
        in      al,42h
        jmp     $+2
        xchg    ah,al
        neg     ax
        push    ax
        in      al,61h
        jmp     $+2
        and     al,0FDh
        out     61h,al
        pop     ax di si
        ret
        ENDP

        END
