/*****************************************************************************/
/* CPUTYPE.C    C/C++ TMi0SDGL interface module                 Version 2.01 */
/*                                                                           */
/* Too-Much-in-0ne-So-Don't-Get-Lost(tm) CPU/FPU detection library.          */
/* Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.                     */
/*****************************************************************************/
/* This file contains high-level detection routines                          */

#define __LIB__         /* we're compiling with library version of header */
#include "tmi0sdgl.h"
#include "string.h"

byte lo(word value)
{
 asm    mov  ax,value;
 return _AL;
}

byte hi(word value)
{
 asm    mov  ax,value;
 asm    xchg ah,al;
 return _AL;
}

char * CyrixModel( void )
/* distinguishes Cyrix CPU model based on DIR0/DIR1 contents */
{
 byte DIR0 = lo(getCyrixModel());
 byte DIR1 = hi(getCyrixModel());
 byte isTI = ((DIR1 & 0x80) != 0);
 switch(DIR0) {
  case 0:    return("Cyrix Cx486SLC");
  case 1:    return("Cyrix Cx486DLC");
  case 2:    return("Cyrix Cx486SL2");
  case 3:    return("Cyrix Cx486DL2");
  case 4:    return("Cyrix Cx486SRx");
  case 5:    return("Cyrix Cx486DRx");
  case 6:    return("Cyrix Cx486SRx2");
  case 7:    return("Cyrix Cx486DRx2");
  case 8:    return("Cyrix Cx486SRu");
  case 9:    return("Cyrix Cx486DRu");
  case 0x0A: return("Cyrix Cx486SRu2");
  case 0x0B: return("Cyrix Cx486DRu2");
  case 0x10: return("Cyrix Cx486S");
  case 0x11: return("Cyrix Cx486S2");
  case 0x12: return("Cyrix Cx486Se");
  case 0x13: return("Cyrix Cx486S2e");
  case 0x1A:
             extFlags |= efHasFPUonChip;
             if(isTI)
              return("Texas Instruments Ti486DX");
             else
              return("Cyrix Cx486DX");
  case 0x1B:
             extFlags |= efHasFPUonChip;
             if(DIR1 == 0x0B)
              return("SGS-Thomson ST486DX2");
             else
             if(isTI || (DIR1==0x32))
              return("Texas Instruments Ti486DX2");
             else
              return("Cyrix Cx486DX2");
  case 0x1F:
             extFlags |= efHasFPUonChip;
             if(isTI)
              return("Texas Instruments Ti486DX4");
             else
              return("Cyrix Cx486DX4");
  case 0x28: return("Cyrix 5x86-S (clock x1 mode)");
  case 0x29: return("Cyrix 5x86-S (clock x2 mode)");
  case 0x2A: return("Cyrix 5x86-P (clock x1 mode)");
  case 0x2B: return("Cyrix 5x86-P (clock x2 mode)");
  case 0x2C: return("Cyrix 5x86-S (clock x4 mode)");
  case 0x2D: return("Cyrix 5x86-S (clock x3 mode)");
  case 0x2E: return("Cyrix 5x86-P (clock x4 mode)");
  case 0x2F: return("Cyrix 5x86-P (clock x3 mode)");
  case 0x20:
  case 0x21:
  case 0x22:
  case 0x23:
  case 0x24:
  case 0x25:
  case 0x26:
  case 0x27:
             cpu = CxM1;
             extFlags |= efHasFPUonChip;
             return("Cyrix 5x86 (M1sc)");
  case 0x30: return("Cyrix 6x86-S (clock x1 mode)");
  case 0x31: return("Cyrix 6x86-S (clock x2 mode)");
  case 0x32: return("Cyrix 6x86-P (clock x1 mode)");
  case 0x33: return("Cyrix 6x86-P (clock x2 mode)");
  case 0x34: return("Cyrix 6x86-S (clock x4 mode)");
  case 0x35: return("Cyrix 6x86-S (clock x3 mode)");
  case 0x36: return("Cyrix 6x86-P (clock x4 mode)");
  case 0x37: return("Cyrix 6x86-P (clock x3 mode)");
  case 0x38:
  case 0x39:
  case 0x3A:
  case 0x3B:
  case 0x3C:
  case 0x3D:
  case 0x3E:
  case 0x3F:
             cpu = CxM1;
             extFlags |= efHasFPUonChip;
             return("Cyrix 6x86 (M1)");
  case 0x81: /* TI's 486DX4 Data Sheet states that it's DIR0 value is 81h */
             extFlags |= efHasFPUonChip;
             return("Texas Instruments Ti486DX4");
  case 0xEF: return("Cyrix Cx486S_a"); /* this id is software-generated */
  case 0xFD:
             extFlags |= efHasFPUonChip;
             return("Cyrix OverDrive");
  case 0xFE: return("Texas Instruments Ti486SXL");
  default:   return("Cyrix/TI/SGS 486-class processor");
 }
}

char * pascal cpu_Type( void )
 {
  cpuid1Layout cpuid1_;

  if(cpu==0xFF)
   getCPUType();
  switch(cpu) {
   case i80386SX: if(cpu_Speed() > 35)
                   cpu=Am386SX;
                  break;
   case i80386DX: if(cpu_Speed() > 35)
                   cpu=Am386DX;
  } /* switch */
  if(extFlags & efCPUIDSupport)
   {
    cpuid1_.Extra = (cpuid1 & 0xF000) >> 12;
    cpuid1_.Family= (cpuid1 & 0x0F00) >> 8;
    cpuid1_.Model = (cpuid1 & 0x00F0) >> 4;
    cpuid1_.Step  = (cpuid1 & 0x000F);
    switch(cpuid1_.Family) {
     case 4:
            if(!strncmp(cpuid0,"UMC UMC UMC ",12)) /* UMC U5-x 486s */
             switch(cpuid1_.Model) {
              case 1:
                     cpu=umcU5S;
                     break;
              case 2:
                     cpu=umcU5D;
                     break;
              case 3:
                     cpu=umcU5D;
                     return("UMC U486DX2");
              case 5:
                     cpu=umcU5S;
                     return("UMC U486SX2");
              default:
                     cpu=umcU5S;
                     return("Udistinguished UMC U486");
              } /* switch */
             else
             if(!strncmp(cpuid0,"GenuineIntel",12)) /* Intel i486s */
              switch(cpuid1_.Model) {
               case 0: return("Intel i486DX");
               case 1: return("Intel i486DX50");
               case 2: return("Intel i486SX");
               case 3: if ((cpuid1_.Extra & 3) == 1)
                        return("Intel i486DX OverDrive");
                       else
                        return("Intel i486DX");
               case 4: return("Intel i486SL");
               case 5: return("Intel i486SX2");
               case 7: return("Intel i486DX2WB");
               case 8: return("Intel i486DX4");
               case 9: return("Intel i486DX4WB");
               default: if((cpuid1_.Extra & 3) == 1)
                         return("Intel i486 OverDrive");
                        else
                         return("Intel i486 (undistinguished model)");
               } /* switch */
             else
             if(!strncmp(cpuid0,"AuthenticAMD",12)) /* AMD Enhanced Am486s */
              {
              cpu = Am486;
              switch(cpuid1_.Model) {
               case 3: return("AMD Enhanced Am486DX2");
               case 7: return("AMD Enhanced Am486DX2+");
               case 8: return("AMD Enhanced Am486DX4");
               case 9: return("AMD Enhanced Am486DX4+");
               case 0x0E: return("AMD X5 (Am5x86)");
               case 0x0F: return("AMD X5+ (Am5x86+)");
               default: return("AMD Enhanced Am486DX (undistinguished model)");
               }
              }
             else
              return(strcat(strcat("Unknown 486-class processor (Make: ",(char *)cpuid0),")"));
             break;
     case 5:
             cpu = iPentium;
             if(!strncmp(cpuid0,"CyrixInstead",12))
              return(CyrixModel());
             else
             if(!strncmp(cpuid0,"GenuineIntel",12))
              {
              switch(cpuid1_.Model) {
               case 0: return("Intel Pentium (A-Step)");
               case 1: return("Intel Pentium");
               case 2: cpu = iP54C;
                       return("Intel iP54C");
               case 3: return("Intel iP24T");
               case 4: return("Intel OverDrive for Pentium 3.3v");
               case 5: return("Intel OverDrive for i486DX4");
               case 6: return("Intel OverDrive for Pentium 5v");
               case 7: return("Intel iP54C (> 133MHz)");
               default:
                       if ((cpuid1_.Extra & 3) == 1)
                        return("Intel Pentium OverDrive");
                       else
                       if ((cpuid1_.Extra & 3) == 2)
                        return("Auxiliary Intel P54C (SMP)");
                       else
                        return("Intel Pentium");
               } /* switch */
              } /* if */
             else
             if(!strncmp(cpuid0,"NexGenDriven",12)) /* NexGen is now part of AMD family */
              {
              cpu = Nx586;
              switch(cpuid1_.Model) {
               case 0: return("NexGen Nx586 or Nx586FPU");
               default: return("NexGen 586-class processor (undistinguished)");
               }
              }
             else
             if(!strncmp(cpuid0,"AuthenticAMD",12))
              {
              cpu = amdK5;
              switch(cpuid1_.Model) {
               case 0: return("AMD SSA/5 (K5)");
               case 1: return("AMD 5k86 (K5)");
               case 6: cpu = amdK6;
               default: return("AMD 586-class processor (undistinguished)");
               }
              }
             break;
     case 6:
             cpu = iPentiumPro;
             switch(cpuid1_.Model) {
              case 0 : return("Intel Pentium Pro (P6) A-Step");
              case 1 : return("Intel Pentium Pro (P6)");
              case 3 : if(cpuid1_.Extra == 1)
                        return("Intel Pentium Pro OverDrive");
                       else
                        return("Intel Pentium Pro (P6)");
              case 4 : return("Intel iP55CT (OverDrive for iP54C socket)");
              } /* switch */
             break;
     case 7:
             cpu = iP7;
     } /* switch */
   }
  switch(cpu) {
#ifndef __DPMI__
 #ifndef __Windows__
 /* Under DPMI host or Windows it is not necessary to check for CPUs lower than
    80286 - neither of them works on these CPUs. */
   case i8088      : return("Intel 8088");
   case i8086      : return("Intel 8086");
   case i80C88     : return("Intel 80C88");
   case i80C86     : return("Intel 80C86");
   case i80188     : return("Intel 80188");
   case i80186     : return("Intel 80186");
   case necV20     : return("NEC V20");
   case necV30     : return("NEC V30");
 #endif
#endif
   case i80286     : return("Intel 80286");
   case i80386SX   : return("Intel 80386SX");
   case i80386DX   : return("Intel 80386DX");
   case i386SL     : return("Intel i386SL");
   case ibm386SLC  : return("IBM 386SLC");
   case Am386SX    : return("AMD Am386SX");
   case Am386DX    : return("AMD Am386DX");
   case CT38600    : return("C&T 38600");
   case CT38600SX  : return("C&T 38600SX");
   case RapidCAD   : return("Intel RapidCAD");
   case i486SX     : return("Intel i486SX");
   case i486DX     : return("Intel i486DX or i487SX");
   case ibm486SLC  : return("IBM 486SLC");
   case ibm486SLC2 : return("IBM 486SLC2");
   case ibm486BL3  : return("IBM 486BL3 (Blue Lightning)");
   case Cx486      : return(CyrixModel());
   case umcU5S     : return("UMC U5S");
   case umcU5D     : return("UMC U5SD");
   case Am486      : return("AMD Am486 (undistinguished model)");
   case CxM1       : return(CyrixModel());
   case amdK5      : return("AMD K5");
   case amdK6      : return("AMD K6");
   case Nx586      : return("NexGen Nx586");
   case iPentiumPro: return("Intel Pentium Pro (P6)");
   case iP7        : return("Intel P7 (wow!)");
   default         : return("Unknown CPU");
   } /* switch */
 }

char * pascal fpu_Type( void )
 {
  if(fpu==0xFF)
   {
    cpu_Type();
    getFPUType();
   }
  if(extFlags & efHasFPUonChip)
   fpu = fpuInternal;
  switch(fpu) {
  case fpuInternal: return("Internal");
  case fpuNone:     return("None");
  case i8087:       return("Intel 8087");
  case i80287:      return("Intel 80287");
  case i80287XL:    return("Intel 80287XL");
  case i80387:      return("Intel 80387");
  case rCAD:        return("Intel RapidCAD");
  case cx287:       return("Cyrix 82x87");
  case cx387:       return("Cyrix 83x87");
  case cx487:       return("Cyrix 84x87");
  case cxEMC87:     return("Cyrix EMC87");
  case iit287:      return("IIT 2C87");
  case iit387:      return("IIT 3C87");
  case iit487:      return("IIT 4C87");
  case ct387:       return("C&T 38700");
  case ulsi387:     return("ULSI 83x87");
  case ulsi487:     return("ULSI 84x87");
  case i487sx:      return("Intel i487SX (integrated)");
  case Nx587:       return("NexGen Nx587");
  default:          return("Unknown FPU");
  }
 }

int pascal cpu_Speed( void )
 {
  if(cpu==0xFF)
   cpu_Type();
  return ((speedTable[cpu]*(long)speedShift)/Speed() + 5) / 10;
 }

#ifdef __need_fp_cpu_Speed__ /* this code links in too much and disables
                                TINY model programs to be converted to .COM */

float pascal fcpu_Speed( void )
/* exactly the same as cpu_Speed, but returns floating point result */
 {
  if(cpu==0xFF)
   cpu_Type();
  return ((speedTable[cpu]*(long)speedShift)/Speed() + 5) / 10;
 }

#endif
