/* ----------------------------------------------------------------------------
 * P5INFOC.C     P5 Information Retriever                        Version 2.01
 *
 * This program is part of TMi0SDGL Revision 2 x86 CPU/FPU Detection Library
 * Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.
 --------------------------------------------------------------------------- */

#include "tmi0sdgl.h"
#include <string.h>
#include <stdio.h>

customCpuid A;

void pascal printBullet( dword Flag, char * Message )
 {
  if (cpuFeatures & Flag) /* != 0 */
   printf("  %s\n",Message);
  else
   printf("  %s\n",Message);
 }

void pascal printExtBullet( dword Flag, char * Message )
 {
  if (A.edx & Flag) /* != 0 */
   printf("  %s\n",Message);
  else
   printf("  %s\n",Message);
 }

int cdecl main( void )
{
 char N[48];
 printf("P5 Information Retriever  Version 2.01/C  Copyright(c) 1996 by B-coolWare.\n\nDetected Processor: %s\n\n", cpu_Type());
 if (!(extFlags & efCPUIDSupport))
  {
   puts("Sorry, this CPU does not support CPUID instruction. Information is unavailable.");
   return 0xFF;
  }
 if ( (cpu != amdK6) && /* AMD K6 */
      !((cpu == amdK5) && ((cpuid1 & 0x00F0) == 0x0010)) ) /* AMD 5k86 */
 {
  printf("Make: %s\nFamily: %u Model: %u Step: %u\n\n", cpuid0, (byte)((cpuid1 & 0x0F00) >> 8), (byte)((cpuid1 & 0x00F0) >> 4), (byte)(cpuid1 & 0x000F));
  puts("This CPU has following features ( = present/enabled):");
  printBullet(0x00000001,"FPU on chip");
  printBullet(0x00000002,"Enhanced V86 (VME)");
  printBullet(0x00000004,"I/O Breakpoints");
  printBullet(0x00000008,"Page Size Extensions");
  printBullet(0x00000010,"Time Stamp Counter");
  printBullet(0x00000020,"Pentium-style MSRs");
  printBullet(0x00000040,"Physical Address Extension");
  printBullet(0x00000080,"Machine Check Exception");
  printBullet(0x00000100,"CMPXCHG8B Instruction");
  if (cpu == amdK5) /* AMD SSA/5 */
   printBullet(0x00000200,"Page Global Extensions");
  else
   printBullet(0x00000200,"CPU contains enabled APIC on chip");
  printBullet(0x00001000,"Memory Type Range Registers");
  if (cpu != amdK5)
   printBullet(0x00002000,"Page Global Extensions");
  printBullet(0x00004000,"Machine Check Architecture");
  printBullet(0x00008000,"CMOVcc (FCMOVcc and FCOMI) instructions");
  printBullet(0x00800000,"MMX (MultiMedia eXtension) instructions");
 }
 else /* AMD K6 has extended CPUID levels and info */
 {
  getCPUID(0x80000002,&A);
  memcpy(&N,&A,16);
  getCPUID(0x80000003,&A);
  memcpy(&N[16],&A,16);
  getCPUID(0x80000004,&A);
  memcpy(&N[32],&A,16);
  printf("AMD K5/K6 Extended Info. Part Name: %s\n\n",N);
  getCPUID(0x80000005,&A);
  printf("Code Cache size: %uKb, Data Cache size: %uKb.\n",(byte)(A.ecx >> 24), (byte)(A.edx >> 24));
  puts("This CPU has following features ( = present/enabled):");
  getCPUID(0x80000001,&A);
  printExtBullet(0x00000001,"FPU on chip");
  printExtBullet(0x00000002,"Virtual Mode Extensions");
  printExtBullet(0x00000004,"Debugging Extension");
  printExtBullet(0x00000008,"Page Size Extension");
  printExtBullet(0x00000010,"Time Stamp Counter");
  printExtBullet(0x00000020,"Model Specific Registers");
  printExtBullet(0x00000080,"Machine Check Exception");
  printExtBullet(0x00000100,"CMPXCHG8B instruction");
  printExtBullet(0x00000400,"SYSCALL/SYSRET extensions");
  printExtBullet(0x00002000,"Page Global Extensions");
  printExtBullet(0x00008000,"CMOVcc instructions");
  printExtBullet(0x00010000,"FCMOVcc/F(U)COMI(P) instructions");
  printExtBullet(0x00800000,"MMX (MultiMedia eXtension) instructions");
 }
 return 0;
}
