{ --------------------------------------------------------------------------- }
{ P5INFOP.PAS   P5 Information Retriever                        Version 2.01  }
{                                                                             }
{ This program is part of TMi0SDGL Revision 2 x86 CPU/FPU Detection Library   }
{ Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.                       }
{ --------------------------------------------------------------------------- }

program P5InfoP;

uses
    CPUType;

procedure printBullet( Flag : LongInt; Message : String );
 begin
  if (cpuFeatures and Flag) = Flag then
   WriteLn('  '+Message)
  else
   WriteLn('  '+Message);
 end;

var
    A : customCpuid;

procedure printExtBullet( Flag : LongInt; Message : String );
 begin
  if (A.edx and Flag) = Flag then
   WriteLn('  '+Message)
  else
   WriteLn('  '+Message);
 end;

var S : String[12];
    N : String[48];

begin
 WriteLn('P5 Information Retriever  Version 2.01/P  Copyright(c) 1996 by B-coolWare.');
 WriteLn;
 WriteLn('Detected Processor: ',cpu_Type);
 WriteLn;
 if (extFlags and efCPUIDSupport) = 0 then
  begin
   WriteLn('Sorry, this CPU does not support CPUID instruction. Information is unavailable.');
   Halt;
  end;
 if (cpu <> amdK6) and { AMD K6 }
    not ((cpu = amdK5) and ((cpuid1 and $00F0) = $0010)) then { AMD 5k86 }
  begin
   S := cpuid0;
   WriteLn('Make: ',S);
   WriteLn('Family: ',(cpuid1 and $0F00) shr 8,' Model: ',(cpuid1 and $00F0) shr 4,' Step: ',cpuid1 and $000F);
   WriteLn;
   WriteLn('This CPU has following features ( = present/enabled):');
   printBullet($00000001,'FPU on chip');
   printBullet($00000002,'Enhanced V86 (VME)');
   printBullet($00000004,'I/O Breakpoints');
   printBullet($00000008,'Page Size Extensions');
   printBullet($00000010,'Time Stamp Counter');
   printBullet($00000020,'Pentium-style MSRs');
   printBullet($00000040,'Physical Address Extension');
   printBullet($00000080,'Machine Check Exception');
   printBullet($00000100,'CMPXCHG8B Instruction');
   if cpu = amdK5 then { AMD SSA/5 }
    printBullet($00000200,'Page Global Extensions')
   else
    printBullet($00000200,'CPU contains enabled APIC on chip');
   printBullet($00001000,'Memory Type Range Registers');
   if cpu <> amdK5 then
    printBullet($00002000,'Page Global Extensions');
   printBullet($00004000,'Machine Check Architecture');
   printBullet($00008000,'CMOVcc (FCMOVcc and FCOMI) instructions');
   printBullet($00800000,'MMX (MultiMedia eXtension) instructions');
  end
 else {AMD K6 has extended CPUID levels and information }
  begin
   getCPUID($80000002,@A);
   Move(A,N[1],16);
   getCPUID($80000003,@A);
   Move(A,N[17],16);
   getCPUID($80000004,@A);
   Move(A,N[33],16);
   WriteLn('AMD K5/K6 Extended Info. Part Name: ',N);
   getCPUID($80000005,@A);
   WriteLn('Code Cache size: ',Byte(A.ecx shr 24),'Kb, Data Cache size: ',Byte(A.edx shr 24),'Kb.');
   WriteLn;
   getCPUID($80000001,@A);
   WriteLn('This CPU has following features ( = present/enabled):');
   printExtBullet($00000001,'FPU on chip');
   printExtBullet($00000002,'Virtual Mode Extensions');
   printExtBullet($00000004,'Debugging Extension');
   printExtBullet($00000008,'Page Size Extension');
   printExtBullet($00000010,'Time Stamp Counter');
   printExtBullet($00000020,'Model Specific Registers');
   printExtBullet($00000080,'Machine Check Exception');
   printExtBullet($00000100,'CMPXCHG8B instruction');
   printExtBullet($00000400,'SYSCALL/SYSRET extensions');
   printExtBullet($00002000,'Page Global Extensions');
   printExtBullet($00008000,'CMOVcc instructions');
   printExtBullet($00010000,'FCMOVcc/F(U)COMI(P) instructions');
   printExtBullet($00800000,'MMX (MultiMedia eXtension) instructions');
  end;
end.
