; -----------------------------------------------------------------------------
; REALCODE.ASM - Real Mode Code for TMi0SDGL 2                    Version 2.01
;
; Too-Much-in-0ne-So-Don't-Get-Lost(tm) Revision 2 CPU/FPU Detection Library
; Copyright(c) 1996 by B-coolWare. Written by Bobby Z.
; -----------------------------------------------------------------------------
; This file contains low-level routines used in TMi0SDGL 2.
;
; global vars/procs/includes section ------------------------------------------
;
        INCLUDE HEADER.ASH

        PUBLIC  getCPUType              ; returns CPU index
        PUBLIC  getFPUType              ; returns FPU index
        PUBLIC  getCyrixModel           ; returns Cx486 model index
        PUBLIC  CxCPUIDEnable           ; enables CPUID on Cyrix 5x86
                                        ; and 6x86
        PUBLIC  getCPUID                ; get CPUID values for specified lvl
        PUBLIC  isV86                   ; returns True if in V86 mode, False
                                        ; otherwise

;
; code section ----------------------------------------------------------------
;

getCPUType      proc    DIST
;
; here's where all the low-level work done
;
        mov     cpu,i8088       ; assume 8088
        call    near ptr check80286
        jc      @@Q1            ; not a 286+ - continue with 8x/18x/NEC
        mov     cpu,i80286
        call    near ptr check386
        jc      @@Q             ; a 286 - stop
        mov     cpu,i80386sx
        call    near ptr check386sl
        jc      @@chkCT386
        mov     cpu,i386sl      ; 386SL - stop
        jmp     @@Q
@@chkCT386:
        call    near ptr checkCT38600
        jc      @@386sx         ; AMD/Intel 386 POPAD bug detected - no need
                                ; to check for 486+...
        mov     cpu,ct38600
@@chk486:
        call    near ptr check486
        jc      @@Q3            ; not a 486+ - check SX/DX
        mov     cpu,i486sx
        call    checkCyrix      ; check if running on Cyrix CPU
        jc      @@checkCPUID
        mov     cpu,Cx486       ; assume Cx486
        call    CxCPUIDEnable   ; enable CPUID on Cx5x86 and 6x86, it's
                                ; disabled by default. This is a bit dangerous
                                ; but should not affect Cx486's
        .386
@@checkCPUID:
        pushfd                  ; check if CPUID instruction is supported
        pushfd
        pop     eax
        mov     ebx,eax
        xor     eax,EF_ID       ; try flipping ID bit of EFLAGS
        push    eax
        popfd
        pushfd
        pop     eax
        popfd
        cmp     eax,ebx
        jz      @@Q4            ; the bit was not flipped - no CPUID
        or      extFlags,efCPUIDSupport
        clr     eax
        idcpu                   ; get detailed CPU info via CPUID
        mov     _dp cpuid0,ebx
        mov     _dp cpuid0[4],edx
        mov     _dp cpuid0[8],ecx
        clr     eax     ; this code assumes that every CPU implements CPUID
        inc     al      ; at least to level 1...
        idcpu
        mov     cpuid1,eax
        mov     cpuFeatures,edx
        test    dl,1
        jz      @@10
        or      extFlags,efHasFPUOnChip
@@10:
        and     ax,0F00h        ; map out CPU family field
        cmp     ah,4            ; family is 4 - 486?
        jz      @@Q
        mov     cpu,iPentium
        cmp     ah,5            ; family is 5 - pentium?
        jz      @@Q
        mov     cpu,iPentiumPro
        cmp     ah,6            ; family is 6 - pentium pro?
        jz      @@Q
        mov     cpu,iP7
        jmp     @@Q
@@Q1:
        call    near ptr check8018x     ; check for shift counter wrap
        jc      @@2
        mov     cpu,i80188
        jmp     @@2_buf
@@2:
        call    near ptr checkNEC       ; check for true 808x rep es: lodsb bug
        jc      @@2_buf
        mov     cpu,necV20
        ; this can be NEC or Intel CMOS-tech CPU, continue testing
        call    near ptr check80C8x     ; check for AAD 16 undocumented opcode
        jc      @@2_buf
        mov     cpu,i80c88
@@2_buf:
        call    near ptr checkQueueSize ; detect CPU prefetch queue size to
        jcxz    @@Q                     ; distinguish 88 from 86
        inc     cpu
        jmp     @@Q
@@Q3:
        call    near ptr checkNexGen
        jc      @@Q2
        mov     cpu,Nx586
        jmp     @@Q
@@Q2:
        call    near ptr checkIBMmsrs ; this routine will update cpu by itself
        jc      @@Q               ; unlike others, this routine sets CF on
                                  ; successful detect
@@386sx:
        call    near ptr check386sx
        jc      @@Q
        inc     cpu
        jmp     @@Q
@@Q4:
        cmp     cpu,Cx486
        jz      @@Q
@@1:
        call    checkIBMmsrs3     ; unlike others, this routine sets CF on
        jc      @@Q               ; successful detect
        call    check486sx
        jc      @@Q
        inc     cpu
@@Q:
        ret
        endp

        .8086

        db      13,10
        db      'TMi0SDGL Revision 2 CPU/FPU Detection Library  Version 2.01',13,10
        db      'Copyright(c) 1996 by B-coolWare.        Written by Bobby Z.',13,10
        db      13,10
        db      'Simply the best...',13,10

checkQueueSize:
; tests prefetch queue size on 88, 86, C88, C86, 188, 186, V20 and V30
; returns cx = 0 -> x88, cx = 1 -> x86
        push    es di
        mov     _bp cs:[@@0],41h        ; to make this routine reentrant
        std
        push    cs
        pop     es
        ldi     @@2
        mov     al,_bp cs:[@@1]
        mov     cx,3
        cli
        rep     stosb
        cld             ; 1
        nop             ; 2
        nop             ; 3
        nop             ; 4     <- 80x88 will cut here and inc cx instruction
@@0:    inc     cx      ; 5        will be overwritten by sti, else we'll get
@@1:                    ;          cx = 1, which indicates 80x86
        sti             ; 6
@@2:
        sti
        pop     di es
        retn
        endp

check80286:
; check for 286+
        push    sp
        pop     ax
        cmp     ax,sp           ; push sp == {sp-=2, [sp]=sp} on < 80286
        jnz     Nope            ; push sp == {[sp-2]=sp, sp-=2} on 80286+
Yes:
        clc
        retn
Nope:
        stc
        retn

check8018x:
; check for 8018x
        mov     cl,33
        clr     ax
        dec     ax
        shl     ax,cl
        jnz     Yes             ; 8018x chips shift only (cl mod 32) bits
        jmp     Nope

checkNEC:
; check for NEC V20/V30
        mov     cx,2            ; test if following instruction will be
                                ; repeated twice.
        db      0F3h,26h,0ACh   ; rep es: lodsb
        jcxz    Yes             ; intel non-CMOS chips do not care of rep
        jmp     Nope            ; before segment prefix override, NEC and
                                ; CMOS-tech ones does.

check80C8x:
; derived from code provided by Alex Bachin
        mov     ax,0102h
        db      0D5h,10h        ; AAD 16 opcode - intel only, undocumented
        cmp     al,12h          ; did it work?
        jnz     Nope            ; nope - probably a NEC chip
        jmp     Yes

; ---------
; check386sl
;
; code provided by Alex Bachin, slightly modified to fit my coding style
outw    macro   reg,value
; out with wait
        out     reg,value
        jmp     $+2
        endm

check386sl:
; this code plays with chipset/on-chip CPU registers, thus it may crash/reboot
; the machine on some chipsets/CPUs... I did not test it!!!
        cli
        in      ax,22h
        mov     cx,ax
        test    cl,1
        jz      @@sl_1
        mov     ax,8000h
        outw    23h,al
        xchg    ah,al
        outw    22h,al
        outw    22h,ax
        in      ax,22h
        test    al,1
        jz      @@sl_2
@@sl_1:
        mov     ax,cx
        or      ah,1
        outw    22h,ax
        in      ax,22h
        test    al,1
        jnz     @@sl_2
        mov     ax,8000h
        outw    23h,al
        xchg    ah,al
        outw    22h,al
        outw    22h,ax
        in      ax,22h
        test    al,1
        jz      @@sl_2
        mov     ax,cx
        test    al,1
        jnz     @@sl_3
        or      ah,1
        outw    22h,ax
        sti
        jmp     Yes
@@sl_2:
        mov     ax,cx
        outw    22h,ax
@@sl_3:
        sti
        jmp     Nope

check386:
; check for 386+, technique is blessed by Intel
        mov     ax,7000h
        pushf
        push    ax
        popf
        pushf
        pop     ax
        popf
        and     ah,70h          ; check for flags - only 386+ has them
        jz      Nope            ; if ah=0 than this is 286
        jmp     Yes

        .386

checkCT38600:
; check for C&T 38600
        mov     esi,32          ; give it 32 tries
        mov     eax,12345678h   ; load a value
        mov     ebx,eax         ; save it for reference
        sub     edx,edx         ; set edx+edi to point to DS:0
        sub     edi,edi
@@ct_loop:
        pushad                  ; push all registers
        popad                   ; pop all registers
        mov     ecx,[edx+edi]   ; and do a memory access
        cmp     eax,ebx         ; did eax changed?
        jnz     Nope            ; YES! this is an Intel/AMD 386 - they have
        dec     esi             ; POPAD bug: mem access after popad changes
        jnz     @@ct_loop       ; eax contents
        jmp     Yes             ; all 32 tries passed - should be C&T38600

check486:                       ; this code is blessed by Intel, donated to
                                ; public domain by CompaQ.
        mov     ax,sp
        and     sp,0FFFCh       ;round down to a dword boundary
        pushfd
        pushfd
        pop     edx
        mov     ecx,edx
        xor     edx,EF_AC       ;toggle AC bit
        and     ecx,EF_AC
        push    edx
        popfd
        pushfd
        pop     edx
        popfd                   ;restore original flags
        mov     sp,ax           ;restore original stack pointer
        and     edx,EF_AC

        cmp     edx,ecx
        jnz     Yes             ;it's a 486
        jmp     Nope

        .386p

check386sx:
; check for SX version
        mov     eax,cr0
        mov     ecx,eax
        xor     eax,MSW_ET      ; flipping ET bit
        mov     cr0,eax
        mov     eax,cr0
        mov     cr0,ecx         ; restoring previous value of CR0
        xor     eax,ecx         ; did it flip ok?
        jz      Nope            ; SX chips do not allow to change bus width
        jmp     Yes

        .8087
check486sx:
; check for SX version
        mov     eax,cr0
        mov     ecx,eax
        xor     eax,MSW_NE      ; flipping NE bit
        mov     cr0,eax
        mov     eax,cr0
        mov     cr0,ecx         ; restoring previous value of CR0
        xor     eax,ecx         ; did it flip ok?
        jnz     Yes             ; SX chips do not allow to change NE bit
                                ; but some SX'es pass this test as DXes...
        mov     fpuWord,0       ; ... so we'll do some more tests
        fninit
        fstcw   fpuWord
        cmp     fpuWord,3F7h    ; 487SX returns these fpu flags
        jnz     Nope
        jmp     Yes

checkIBMmsrs:
; the following three checkIBMmsrsX routines attempt to read IBM-specific
; MSRs #1000, #1002 and #1004. Because RDMSR with invalid index will cause
; exception 13 and rdmsr itself may cause exception 6 on CPU that do not
; support it, we should be able to intercept both exceptions, thus the code
; should run either in real mode or on CPL0.
        smsw    ax
        test    al,1            ; we can only do this nasty code in real mode...
        jnz     @@Qs1
        push    ds
        mov     ax,350Dh
        int     21h
        push    es
        push    bx
        push    cs
        pop     ds
        mov     dx,offset @@trap06
        mov     ax,250Dh        ; intercept GPF exception
        int     21h
        mov     ax,3506h
        int     21h
        push    es
        push    bx
        mov     dx,offset @@trap06
        mov     ax,2506h        ; and Invalid Instruction exception
        int     21h
        readmsr 1000h
                                ; We'll get Exception 13 if this MSR is not
        stc                     ; valid or Exception 06 if this is not IBM386.
        mov     cpu,ibm386slc   ; IBM 386SLC
        jmp     @@Qs
@@trap06:                       ; similar action is taken on both exceptions,
        add     sp,4            ; so we don't need to setup different handlers
        popf                    ; for each exception.
        clc
@@Qs:
        pop     dx
        pop     ds
        pushf
        mov     ax,2506h
        int     21h
        popf
        pop     dx
        pop     ds
        pushf
        mov     ax,250Dh
        int     21h
        popf
        pop     ds
@@Qs1:
        ret
        endp

checkIBMmsrs2:
        call    near ptr checkIBMmsrs ; first check if this is IBM 486SLC chip
        jnc     @@Qi
        push    ds
        mov     ax,350Dh        ; we don't need to intercept Exception #6 here,
        int     21h             ; for it is proved that RDMSR instruction is
        push    es              ; valid for current CPU. But the register we're
        push    bx              ; trying to read may be invalid...
        push    cs
        pop     ds
        mov     dx,offset @@trap0D2
        mov     ax,250Dh
        int     21h
        readmsr 1002h           ; try to read 486SLC2 specific MSR
        mov     cpu,ibm486slc2  ; IBM 486SLC2
        jmp     @@Qi2
@@trap0D2:
        add     sp,4
        popf
        stc
        mov     cpu,ibm486slc   ; IBM 486SLC
@@Qi2:
        pop     dx
        pop     ds
        pushf
        mov     ax,250Dh
        int     21h
        popf
@@Qi:
        ret
        endp

checkIBMmsrs3:
        call    near ptr checkIBMmsrs2
        jnc     @@Qi4
        push    ds
        mov     ax,350Dh        ; we don't need to intercept Exception #6 here,
        int     21h             ; for it is proved that RDMSR instruction is
        push    es              ; valid for current CPU. But the register we're
        push    bx              ; trying to read may be invalid...
        push    cs
        pop     ds
        mov     dx,offset @@trap0D3
        mov     ax,250Dh
        int     21h
        readmsr 1004h           ; try to read 486BL3 specific MSR
        mov     cpu,ibm486bl3
        jmp     @@Qi3
@@trap0D3:
        add     sp,4
        popf
        stc
@@Qi3:
        pop     dx
        pop     ds
        pushf
        mov     ax,250Dh
        int     21h
        popf
@@Qi4:
        ret
        endp

checkCyrix:                     ; this code provided by Cyrix Corp.
        clr     ax
        sahf                    ; load flags, bit 1 always = 1
        mov     ax,5
        mov     bx,2
        div     bl              ; do an operation that does not change flags
        lahf                    ; get flags
        cmp     ah,2            ; did flags changed?
        jne     Nope            ; yes, they did - not a Cyrix CPU
        jmp     Yes             ; didn't - Cyrix CPU

checkNexGen:                    ; this code provided by NexGen Corp.
        mov     ax,5555h
        xor     dx,dx
        mov     cx,2
        div     cx
        jnz     Nope            ; Nx586 doesn't change ZF on division while
        jmp     Yes             ; others do

; -----------------------------------------------------------------------------
; checkWeitek routine follows

checkWeitek     proc near
; check for Weitek coprocessor presence, just checking if BIOS feature flag
; for Weitek FPU is set.
        cmp     cpu,i80386sx
        jb      @@1
        .386
        clr     eax
        int     11h
        test    eax,1000000h
        .8086
        jz      @@1
        or      extFlags,efWeitekPresent        ; Weitek FPU present
        jmp     @@2
@@1:
        and     extFlags,not efWeitekPresent
@@2:
        ret
        endp

; -----------------------------------------------------------------------------
; checkEmulator routine follows

checkEmulator   proc
; returns CF = 1 if FPU emulator detected, CF = 0 otherwise
        and     extFlags,not efEmulatedFPU    ; assume no emulator
        cmp     cpu,i80386sx   ; check for 386+ to assure that FPU emulation is
        jb      @@2            ; possible, avoid check if not 386 or higher.
        .286p
        push    ax
        smsw    ax
        test    al,04           ; simply check fpu emulation bit in MSW
        jz      @@1
        or      extFlags,efEmulatedFPU
@@1:
        pop     ax
@@2:
        ret
        endp

        .8086

; -----------------------------------------------------------------------------
; getFPUType routine follows

getFPUType      proc    DIST
LOCAL   fpuWord, fpuDWord : DWORD, fpuTera : TBYTE, fpuEnv : BYTE : 14

; cpu variable should already have valid CPU code on entry!

        mov     fpu,fpuNone     ; assume no FPU present
        fninit
        clr     cx
        jmp     $+2             ; just to make sure we have enough time for
                                ; FPU to initialize
        mov     fpuWord,5A5Ah
        fnstsw  fpuWord
        mov     ax,fpuWord
        test    al,al
        jnz     @@L161          ; FPU wasn't initialized - no FPU at all
        fnstcw  fpuWord         ; check the control word also
        mov     ax,fpuWord
        and     ax,103Fh
        cmp     ax,3Fh
        jne     @@L161
        mov     fpu,i8087       ; assume 8087
        fstenv  fpuEnv
        and     fpuWord,0FF7Fh
        fldcw   fpuWord
        fdisi
        fstcw   fpuWord
        wait
        test    fpuWord,80h
        jnz     @@L161
        .286p
        .287
        mov     fpu,i80287      ; assume 80287
        fninit                  ; checking if -Inf <> +Inf
        fld1                    ; 287 erroneously claim that they are equal
        fldz
        fdivp   st(1),st
        fld     st
        fchs
        fcompp
        fstsw   fpuWord
        wait
        mov     ax,fpuWord
        sahf
        jz      @@L161          ; -Inf <> +Inf -> 287XL or 387 and up
        mov     fpu,i80387      ; assume 80387
        cmp     cpu,i80286      ; IIT x87's cannot work with CPUs prior to 286
        jb      @@L35           ; so we disable the test on them too.
@@checkIIT:
        fld     fpuDenormal
        fadd    st(0),st        ; IIT will produce zero result while all others
        fnstsw  ax              ; won't
        test    al,02h
        jnz     @@L35           ; not an IIT chip
        cmp     fpu,i80387      ; tested as 80387?
        jz      @@300
        mov     fpu,iit287      ; this is IIT 2C87
        jmp     @@L161
@@300:
        cmp     cpu,i486sx      ; it's a 486?
        jb      @@301
        mov     fpu,iit487      ; assume IIT 4C87
        jmp     @@L161
@@301:
        mov     fpu,iit387      ; this is IIT 3C87
        jmp     @@L161
@@L35:
; checking for Cyrix FPUs
        fninit
        fldpi
        f2xm1
        fstp    fpuDWord
        wait
        cmp     _wp fpuDWord[2],3FC9h
        jne     @@L15           ; Cyrix FPUs are known to return this value
        cmp     cpu,i80286
        ja      @@L351
        mov     fpu,cx287       ; this is Cyrix ?C87
        jmp     @@L15
@@L351:
        cmp     cpu,i486sx
        jb      @@L352
        mov     fpu,cx487
        jmp     @@L15
@@L352:
        mov     fpu,cx387
@@L15:
; testing for ULSI FPUs
        fninit
        fldcw   fpu_53bit_prec
        fld     _tp fpuOp1
        fld1
        faddp   st(1),st
        fstp    fpuTera
        fnstsw  ax
        wait
        test    al,20h
        jnz     @@L16
        cmp     _bp fpuTera,0F8h
        jnz     @@L16
        cmp     _bp fpuTera[9],40h
        jnz     @@L16
        mov     fpu,ulsi387
        cmp     cpu,i486sx
        jb      @@L161
        mov     fpu,ulsi487
        jmp     @@L161
@@L16:
; testing for Cyrix EMC87
        fnstcw  fpuWord
        or      _bp fpuWord[1],80h
        fldcw   fpuWord
        fstcw   fpuWord
        wait
        test    _bp fpuWord[1],80h
        jz      @@L162
        mov     fpu,cxEMC87
        jmp     @@L161
@@L162:
; testing for C&T 38700
        cmp     cpu,i80386sx
        jb      @@L161
        fninit
        fldpi
        f2xm1
        fld1
        fchs
        fldpi
        fscale
        fstp    st(1)
        fcompp
        fstsw   ax
        wait
        sahf
        jnz     @@L161
        mov     fpu,ct387
@@L161:
        cmp     cpu,i80286      ; 286...?
        jnz     @@30
        cmp     fpu,i80387      ; ...and FPU tested as 387...?
        jnz     @@30
        mov     fpu,i80287xl    ; then assume 80287XL - tricky
@@30:
        cmp     cpu,i486sx
        jae     @@302
        cmp     cpu,i80286
        jbe     @@302
        fninit                  ; this test is valid for 386 only
        fbstp   fpuTera
        cmp     _bp fpuTera[7],0C0h     ; RapidCAD stores C0, 387 - 80
        jnz     @@302
        mov     cpu,RapidCAD
        mov     fpu,rCAD
        jmp     @@restore
@@302:
        cmp     cpu,i486sx      ; i486sx ?
        jb      @@restore       ; we're done
        cmp     cpu,i486dx
        ja      @@31
        jz      @@Internal      ; already know this is 486DX
        cmp     fpu,i80387      ; 387?
        jnz     @@33
        mov     cpu,i486dx      ; assume 486DX or 487SX
@@Internal:
        mov     fpu,fpuInternal ; assume internal FPU
        or      extFlags,efHasFPUonChip
        jmp     @@restore
@@33:
        cmp     cpu,i486dx      ; 486DX with non-Intel FPU???
        jnz     @@31
        dec     cpu             ; then this is i486SX with non-Intel FPU.
        jmp     @@restore
@@31:
        cmp     cpu,Nx586       ; Nx586?
        jnz     @@restore
        cmp     fpu,i80387      ; there's an 386-compatible FPU?
        jnz     @@restore
        mov     fpu,Nx587       ; assume Nx587 - others shouldn't work
@@restore:
        cmp     fpu,fpuNone     ; any 87 present?
        jz      @@fin
        fldenv  fpuEnv          ; yes - restore x87 environment
@@fin:
        .8086
        call    checkWeitek     ; check for Weitek FPU presense
        call    checkEmulator   ; check for FPU emulation
        ret
        endp

; -----------------------------------------------------------------------------
; isV86 routine follows
;

isV86   proc    DIST
        .286p
        smsw    ax
        and     al,1    ; bit 1 is set if in Protected Mode, in DOS this
                        ; automatically means V86...
        ret
        endp

; -----------------------------------------------------------------------------
; getCyrixModel routine follows
; method provided by Cyrix


read_reg        macro reg
; macro for reading CPU hidden register reg
        pushf
        cli
        mov     al,reg
        out     22h,al
        in      al,23h
        popf
        endm

write_reg       macro reg
; macro for writing a value in AH to CPU hidden register reg
        pushf
        cli
        mov     al,reg
        out     22h,al
        xchg    al,ah
        out     23h,al
        popf
        endm

getCyrixModel   proc    DIST    ; this code provided by Cyrix.
        clr     dx      ; dh = t1, dl = t2
        read_reg 0C2h
        mov     bl,al
        xor     al,4    ; flip bit 2 of CCR2
        mov     ah,al
        write_reg 0C2h
        read_reg  0C0h  ; dummy read to set up bus
        read_reg  0C2h  ; get CCR2 value
        cmp     al,bl   ; did bit 2 flip?
        jz      @@1
        inc     dh
@@1:
        mov     ah,bl
        write_reg 0C2h  ; restore previous CCR2 value

        read_reg  0C3h  ; read CCR3
        mov     bl,al
        xor     al,80h  ; flip bit 7 of CCR3
        write_reg 0C3h
        read_reg  0C0h
        read_reg  0C3h
        cmp     bl,al   ; did bit 7 flip?
        jz      @@2
        inc     dl
@@2:
        mov     ah,bl
        write_reg 0C3h  ; restore CCR3

        test    dl,dl   ; t2 = 0? -> DIRx not supported
        jz      @@noDIRx
        read_reg  0FEh
        mov     bl,al   ; bl = DIR0
        read_reg  0FFh
        mov     bh,al   ; bh = DIR1
        jmp     @@done
@@noDIRx:
        test    dh,dh
        jz      @@unknown
        mov     bx,0EFh ; EF = Cx486S_a
        jmp     @@done
@@unknown:
        clr     bx      ; unknown Cyrix chip
        dec     bl      ; return 0FFh as result
@@done:
        mov     ax,bx
        ret
        endp

CxCPUIDEnable   proc    DIST
; enables EFLAGS bit 21 and CPUID instruction on Cyrix 5x86 and 6x86 CPUs
; this code does not affect Cx486's in any way
        read_reg 0C3h
        and     al,0Fh
        or      al,10h
        mov     ah,al
        write_reg 0C3h  ; activate 0001 CR set
        read_reg 0E8h   ; read CCR4
        or      al,80h  ; set bit 7 = 1 -> CPUID enabled
        mov     ah,al
        write_reg 0E8h  ; set new CCR4 value
        ret
        endp

        .386
getCPUID      proc    DIST
; support routine to get CPUID extended info at specified level, used for
; AMD K6 extended information display. Cache info on Pentium Pro and K6 can
; also be retrieved using this routine with Level == 2.
ARG Level: DWORD, Result: DWORD
USES es, di
        mov     eax,Level
        idcpu
        les     di,[Result]
        stosd
        xchg    eax,ebx
        stosd
        xchg    eax,ecx
        stosd
        xchg    eax,edx
        stosd
        ret
        endp

; -----------------------------------------------------------------
; that's all, folks!

        END




