/*****************************************************************************/
/* TMi0SDGL.H   TMi0SDGL 2 C/C++ Header File                    Version 2.01 */
/*                                                                           */
/* Too-Much-in-0ne-So-Don't-Get-Lost(tm) Revision 2 CPU/FPU detection library*/
/* Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.                     */
/*****************************************************************************/
/* defines that affect compilation:

__need_fp_cpu_Speed__   enables compilation of floating point version of
                        cpu_Speed routine. Disabled by default, for this
                        version links in too much code.
__DPMI__                specifies that this code is compiled to run under
                        DPMI
__Windows__             specifies that this code is compiled to run under
                        Windows. Effectively the same as __DPMI__
*/

/* uncomment this if you want floating point version of cpu_Speed to be
   compiled.
#define __need_fp_cpu_Speed__
*/

#ifndef __TMi0SDGL_H
#define __TMi0SDGL_H

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long dword;
typedef void * pointer;

#define efHasFPUonChip  0x0001
#define efWeitekPresent 0x0002
#define efCPUIDSupport  0x0004
#define efDXType        efCPUIDSupport+efHasFPUonChip
#define efEmulatedFPU   0x0008

/* CPU type constants */

#define i8088           0
#define i8086           1
#define i80C88          2
#define i80C86          3
#define i80188          4
#define i80186          5
#define necV20          6
#define necV30          7
#define i80286          8
#define i80386SX        9
#define i80386DX        10
#define i386SL          11
#define ibm386SLC       12
#define Am386SX         13
#define Am386DX         14
#define CT38600         15
#define CT38600SX       16
#define RapidCAD        17
#define i486SX          18
#define i486DX          19
#define ibm486SLC       20
#define ibm486SLC2      21
#define ibm486BL3       22
#define Cx486           23
#define umcU5S          24
#define umcU5D          25
#define Am486           26
#define iPentium        27
#define iP54C           28
#define CxM1            29
#define amdK5           30
#define Nx586           31
#define iPentiumPro     32
#define amdK6           33
#define iP7             34

/* FPU type constants */

#define fpuInternal     100
#define fpuNone         0
#define i8087           1
#define i80287          2
#define i80287XL        3
#define i80387          4
#define rCAD            5
#define cx287           6
#define cx387           7
#define cx487           8
#define cxEMC87         9
#define iit287          10
#define iit387          11
#define iit487          12
#define ct387           13
#define ulsi387         14
#define ulsi487         15
#define i487sx          16
#define Nx587           17

typedef struct { dword eax;
                 dword ebx;
                 dword ecx;
                 dword edx; } customCpuid;


#ifdef  __LIB__

typedef struct { byte Extra;
                 byte Family;
                 byte Model;
                 byte Step; } cpuid1Layout;

#ifdef __cplusplus
 extern "C" {
#endif
 extern byte _dist pascal getCPUType( void ); /* sets cpu variable to CPU code */
 extern byte _dist pascal getFPUType( void ); /* sets fpu variable to FPU code */
 extern word _dist pascal getCyrixModel( void );
 extern word _dist pascal Speed( void );
 extern word _dist pascal getCacheSize( void );
 extern void _dist pascal CxCPUIDEnable( void );
 extern void _dist pascal getCPUID( dword Level, pointer Result );
#ifndef __DPMI__
 #ifndef __Windows__
 extern byte _dist pascal isV86( void );
 #endif
#endif
#ifdef __cplusplus
 }
#endif  /* __cplusplus */

char * pascal cpu_Type( void );
 /* returns cpu name */
char * pascal fpu_Type( void );
 /* returns fpu name */
int pascal cpu_Speed( void );
 /* returns current CPU's clock speed in MHz */
#ifdef __need_fp_cpu_Speed__
float pascal fcpu_Speed( void );
 /* returns current CPU's clock speed in MHz, floating point value */
#endif

/* variables and constants */

byte pascal cpu = 0xFF; /* initialize cpu and fpu as 0xFF, so they will be */
byte pascal fpu = 0xFF; /* detected just once.                             */
word pascal extFlags = 0;
byte pascal cpuid0[12] = {0,0,0,0,0,0,0,0,0,0,0,0};
byte pascal zeroByte = 0; /* this is to make cpuid0 a valid C string so that
                             we can use strncmp() on it */
dword pascal cpuid1 = 0L;
dword pascal cpuFeatures = 0L;

/* following constants should not be accessed from client code, they are for */
/* internal purposes only and should not be changed.                         */
byte pascal fpuDenormal[10] = {1,0,0,0,0,0,0,0,0,0};
byte pascal fpuOp1[10] = {0xF0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x3F};
word pascal fpu_53bit_prec = 0x02F7;
word pascal speedShift = 0;
long pascal speedTable[iP7+1] =
                       {
                        0x0002AD26, /* i8088 */
                        0x0002AD26, /* i8086 */
                        0x0002AD26, /* i80C88 */
                        0x0002AD26, /* i80C86 */
                        0x0000BA6F, /* i80188 */
                        0x0000BA6F, /* i80186 */
                        0x0000E90B, /* necV20 */
                        0x0000DFB9, /* necV30 */
                        0x00006FDC, /* i80286 */
                        0x00007480, /* i80386SX */
                        0x00007480, /* i80386DX */
                        0x00007480, /* i386SL */
                        0x00007480, /* ibm386slc */
                        0x00007415, /* Am386SX */
                        0x00007415, /* Am386DX */
                        0x00007480, /* CT38600 */
                        0x00007480, /* CT38600SX */
                        0x00007415, /* RapidCAD */
                        0x00007480, /* i486SX */
                        0x00007480, /* i486DX */
                        0x00007486, /* ibm486slc */
                        0x00007486, /* ibm486slc2 */
                        0x00007486, /* ibm486bl3 */
                        0x0000668A, /* Cx486 */
                        0x00003C90, /* umcU5S */
                        0x00003C90, /* umcU5D */
                        0x00007480, /* Am486 */
                        0x00007850, /* Pentium */
                        0x00007900, /* P54C */
                        0x00008500, /* CxM1 */
                        0x000061D0, /* amdK5 */
                        0x0000792E, /* Nx586      !!! needs adjustment */
                        0x0000D28C, /* PentiumPro !!! needs adjustment */
                        0x00008500, /* amdK6      !!! needs adjustment */
                        0x00003079  /* P7         !!! needs adjustment */
                       };

#else   /* !__LIB__ */

#ifdef __cplusplus
 extern "C" {
#endif
 /* define interface with library functions... */
 extern char * pascal cpu_Type( void );
 extern char * pascal fpu_Type( void );
 extern int pascal cpu_Speed( void );
#ifdef __need_fp_cpu_Speed__
 extern float pascal fcpu_Speed( void );
#endif
 extern word _dist pascal getCacheSize( void );
 extern void _dist pascal CxCPUIDEnable( void );
 extern void _dist pascal getCPUID( dword Level, pointer Result );
#ifndef __DPMI__
 #ifndef __Windows__
 extern byte _dist pascal isV86( void );
 #endif
#endif

 /* ...and variables */
 extern byte pascal cpu;
 extern byte pascal fpu;
 extern word pascal extFlags;
 extern byte pascal cpuid0[12];
 extern dword pascal cpuid1;
 extern word pascal cpuFeatures;

#ifdef __cplusplus
 }
#endif

#endif  /* __LIB__ */

#endif  /* __TMi0SDGL_H */
