///////////////////////////////////////////////////////////////////////////////
// TMi0SDGL.HPP - CPU and FPU classes interface, TMi0SDGL 2     Version 2.01 //
//                                                                           //
// Too-Much-in-0ne-So-Don't-Get-Lost(tm) Revision 2 CPU/FPU Detection Library//
// Copyright(c) 1996 by B-coolWare.  Written by Bobby Z.                     //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TMi0SDGL_HPP  // avoid reinclusion of this file
#define __TMi0SDGL_HPP

#ifndef __STRING_H
#include <string.h>
#endif
#ifndef __IOSTREAM_H
#include <iostream.h>
#endif
#include "tmi0sdgl.h"

class cCPU {
       public:
        char *Name;
        unsigned int MHz;
        unsigned int CacheSize;
       cCPU(){
              Name = new char[strlen(cpu_Type())+1];
              strcpy(Name,cpu_Type());
              MHz = cpu_Speed();
              if (cpu >= i486SX)
               CacheSize = getCacheSize();
              else
               CacheSize = 0;
            }
       ~cCPU() { delete Name; }
      };

ostream& operator << ( ostream& s, const cCPU& c )
 {
  return s << "Processor: " << c.Name << ", " << c.MHz << "MHz\n";
 }

class cFPU {
       public:
        char *Name;
        cFPU(){
               Name = new char[strlen(fpu_Type())+1];
               strcpy(Name,fpu_Type());
             }
        ~cFPU() { delete Name; }
       };

ostream& operator << ( ostream& s, const cFPU& f )
 {
  return s << "Math unit: " << f.Name << "\n";
 }

#endif // __TMi0SDGL_HPP
