; -----------------------------------------------------------------------------
; TMI0SDGL.INC - Common TMi0SDGL 2 macros and defines             Version 2.01
;
; Too-Much-in-0ne-So-Don't-Get-Lost(tm) Revision 2 CPU/FPU Detection Library
; Copyright(c) 1996 by B-coolWare. Written by Bobby Z.
; -----------------------------------------------------------------------------
;
; defines that affect compilation:
;
; __32bit__     type: define
;               default: not defined
;               purpose: to compile code and data as USE32 segments as well
;                        as use 32-bit version of DPMICODE.ASM.
; should not be defined with Borland Pascal 7 - it does not support 32-bit
; protected mode program generation.
;

; CPU codes

        i8088           equ     0       ; direct detect
        i8086           equ     1       ; direct detect
        i80C88          equ     2       ; direct detect
        i80C86          equ     3       ; direct detect
        i80188          equ     4       ; direct detect
        i80186          equ     5       ; direct detect
        necV20          equ     6       ; direct detect
        necV30          equ     7       ; direct detect
        i80286          equ     8       ; direct detect
        i80386sx        equ     9       ; direct detect
        i80386dx        equ     10      ; direct detect
        i386sl          equ     11      ; direct detect
        ibm386slc       equ     12      ; direct detect (real mode only)
        am386sx         equ     13      ; indirect detect (based on clock frq)
        am386dx         equ     14      ; indirect detect (based on clock frq)
        ct38600         equ     15      ; direct detect
        ct38600sx       equ     16      ; direct detect
        RapidCAD        equ     17      ; direct detect
        i486sx          equ     18      ; direct detect (models distinguished..)
        i486dx          equ     19      ; direct detect (..sometimes)
        ibm486slc       equ     20      ; direct detect (real mode only)
        ibm486slc2      equ     21      ; direct detect (real mode only)
        ibm486bl3       equ     22      ; direct detect (real mode only)
        Cx486           equ     23      ; direct detect (models distinguished)
        umcU5S          equ     24      ; indirect detect (CPUID)
        umcU5D          equ     25      ; indirect detect (CPUID)
        am486           equ     26      ; indirect detect (CPUID)
        iPentium        equ     27      ; direct detect (models distinguished)
        iP54C           equ     28      ; indirect detect (CPUID)
        CxM1            equ     29      ; indirect detect (CPUID)
        amdK5           equ     30      ; indirect detect (CPUID)
        Nx586           equ     31      ; direct detect
        iPentiumPro     equ     32      ; direct detect (models distinguished)
        amdK6           equ     33      ; indirect detect (CPUID)
        iP7             equ     34      ; direct detect (N/A)

; FPU codes

        fpuInternal     equ     100
        fpuNone         equ     0
        i8087           equ     1
        i80287          equ     2
        i80287xl        equ     3
        i80387          equ     4
        rCAD            equ     5
        cx287           equ     6
        cx387           equ     7
        cx487           equ     8
        cxEMC87         equ     9
        iit287          equ     10
        iit387          equ     11
        iit487          equ     12
        ct387           equ     13
        ulsi387         equ     14
        ulsi487         equ     15
        i487sx          equ     16      ; this is actually a 486DX
        Nx587           equ     17

; flags

        EF_AC   equ     00040000h       ; AC bit of EFLAGS
        EF_ID   equ     00200000h       ; ID bit of EFLAGS
        MSW_ET  equ     00000010h       ; ET bit of MSW
        MSW_NE  equ     00000020h       ; NE bit of MSW

        efHasFPUonChip  equ     0001h
        efWeitekPresent equ     0002h
        efCPUIDSupport  equ     0004h
        efDXType        equ     efCPUIDSupport+efHasFPUOnChip
        efEmulatedFPU   equ     0008h

; macros

idcpu   macro           ; a combination macro for TASM 3.x and TASM 4.x
                        ; first don't support CPUID, second does.
 IF ??version LT 400h
        db      0Fh,0A2h
 ELSE
        .586
        cpuid
 ENDIF
        endm

; my PDP-like command macros :)

clr     macro   reg
        sub     reg,reg
        endm

ldx     macro   value
        mov     dx,offset value
        endm

ldi     macro   value
        mov     di,offset value
        endm

lsi     macro   value
        mov     si,offset value
        endm

lbx     macro   value
        mov     bx,offset value
        endm

IF ??version LT 400h

readmsr macro   Reg                     ; new 486 and Pentium instruction
        .386
        mov     ecx,Reg                 ; read MSR #ECX into EDX:EAX
        db      0Fh,32h
        endm
wrtemsr macro   Reg                     ; new 486 and Pentium instruction
        .386
        mov     ecx,Reg                 ; write MSR #ECX from EDX:EAX
        db      0Fh,30h
        endm
ELSE

readmsr macro   Reg
        .586p
        mov     ecx,Reg
        rdmsr
        endm

wrtemsr macro   Reg
        .586p
        mov     ecx,Reg
        wrmsr
        endm

ENDIF

; equivalents

_bp     equ     <byte ptr>
_wp     equ     <word ptr>
_dp     equ     <dword ptr>
_qp     equ     <qword ptr>
_tp     equ     <tbyte ptr>


IFDEF   __32bit__       ; put .386 _BEFORE_ code and data segment declaration
        .386            ; this way code and data segments will be USE32
ENDIF

        .DATA                   ; data segment

GLOBAL  cpu : BYTE
GLOBAL  fpu : BYTE
; many suggestions are made based on following variables
GLOBAL  extFlags : WORD         ; some extra flags (see efXXXX constants)
GLOBAL  cpuid0  : BYTE : 12     ; Maker Id
GLOBAL  cpuid1  : DWORD         ; CPU Submodel/Family/Model/Step
GLOBAL  cpuFeatures : DWORD     ; CPU features

; do not change following variables from your program.

GLOBAL  fpuDenormal : TBYTE     ; is a constant
GLOBAL  fpuOp1  : TBYTE         ; is a constant
GLOBAL  fpu_53bit_prec : WORD   ; is a constant
GLOBAL  speedShift : WORD       ; is a variable

        .CODE                   ; code follows
